/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class DesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private static final ReferenceQueue queue;
    private WeakPCL pcl;
    private final String key;
    private Object value;
    private final Object fallback;

    static void flushUnreferencedProperties() {
        WeakPCL weakPCL;
        while ((weakPCL = (WeakPCL)queue.poll()) != null) {
            weakPCL.dispose();
        }
    }

    private static synchronized void setUpdatePending(boolean bl) {
        updatePending = bl;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Class<?> clazz = UIManager.getLookAndFeel().getClass();
        if (clazz.getPackage().equals(DesktopProperty.class.getPackage())) {
            XPStyle.invalidateStyle();
        }
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            DesktopProperty.updateWindowUI(frameArray[i]);
        }
    }

    private static void updateWindowUI(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            DesktopProperty.updateWindowUI(windowArray[i]);
        }
    }

    public DesktopProperty(String string, Object object) {
        this.key = string;
        this.fallback = object;
        DesktopProperty.flushUnreferencedProperties();
    }

    public Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    protected Object getValueFromDesktop() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (this.pcl == null) {
            this.pcl = new WeakPCL(this, this.getKey(), UIManager.getLookAndFeel());
            toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        }
        return toolkit.getDesktopProperty(this.getKey());
    }

    protected Object getDefaultValue() {
        return this.fallback;
    }

    public void invalidate(LookAndFeel lookAndFeel) {
        this.invalidate();
    }

    public void invalidate() {
        this.value = null;
    }

    protected void updateUI() {
        if (!DesktopProperty.isUpdatePending()) {
            DesktopProperty.setUpdatePending(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    DesktopProperty.updateAllUIs();
                    DesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected Object configureValue(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return new ColorUIResource((Color)object);
            }
            if (object instanceof Font) {
                return new FontUIResource((Font)object);
            }
            if (object instanceof UIDefaults.LazyValue) {
                object = ((UIDefaults.LazyValue)object).createValue(null);
            } else if (object instanceof UIDefaults.ActiveValue) {
                object = ((UIDefaults.ActiveValue)object).createValue(null);
            }
        }
        return object;
    }

    protected String getKey() {
        return this.key;
    }

    static {
        queue = new ReferenceQueue();
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private String key;
        private LookAndFeel laf;

        WeakPCL(Object object, String string, LookAndFeel lookAndFeel) {
            super(object, queue);
            this.key = string;
            this.laf = lookAndFeel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DesktopProperty desktopProperty = (DesktopProperty)this.get();
            if (desktopProperty == null || this.laf != UIManager.getLookAndFeel()) {
                this.dispose();
            } else {
                desktopProperty.invalidate(this.laf);
                desktopProperty.updateUI();
            }
        }

        void dispose() {
            Toolkit.getDefaultToolkit().removePropertyChangeListener(this.key, this);
        }
    }
}

