/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.AVA;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;

class RDN {
    protected AVA[] assertion;

    RDN(int n2) {
        this.assertion = new AVA[n2];
    }

    RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new IOException("X500 RDN");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSet(5);
        this.assertion = new AVA[derValueArray.length];
        int n2 = 0;
        while (n2 < derValueArray.length) {
            this.assertion[n2] = new AVA(derValueArray[n2]);
            ++n2;
        }
    }

    RDN(String string) throws IOException {
        int n2 = string.indexOf(43);
        if (n2 == -1 || n2 > 0 && string.charAt(n2 - 1) == '\\' && string.indexOf(43, n2 + 1) == -1) {
            this.assertion = new AVA[1];
            this.assertion[0] = new AVA(new StringReader(string));
        } else {
            String string2;
            int n3;
            Vector<String> vector = new Vector<String>(3);
            int n4 = 0;
            boolean bl = false;
            int n5 = 0;
            while ((n3 = string.indexOf(43, n5)) > 0) {
                if (string.charAt(n3 - 1) != '\\') {
                    string2 = string.substring(n4, n3).trim();
                    if (string2.length() == 0) {
                        throw new IOException("empty AVA in RDN \"" + string + "\"");
                    }
                    vector.addElement(string2);
                    n4 = n3 + 1;
                }
                n5 = n3 + 1;
            }
            string2 = string.substring(n4).trim();
            if (string2.length() == 0) {
                throw new IOException("empty AVA in RDN \"" + string + "\"");
            }
            vector.addElement(string2);
            this.assertion = new AVA[vector.size()];
            Enumeration enumeration = vector.elements();
            int n6 = 0;
            while (enumeration.hasMoreElements()) {
                this.assertion[n6++] = new AVA(new StringReader((String)enumeration.nextElement()));
            }
        }
    }

    void a(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
    }

    boolean a(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.assertion.length) {
            if (!this.assertion[n2].a(rDN.assertion[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof RDN) {
            return this.a((RDN)object);
        }
        return false;
    }

    DerValue a(ObjectIdentifier objectIdentifier) {
        int n2 = 0;
        while (n2 < this.assertion.length) {
            if (this.assertion[n2].a.equals(objectIdentifier)) {
                return this.assertion[n2].b;
            }
            ++n2;
        }
        return null;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.assertion.length) {
            if (this.assertion[n4].b != null) {
                n2 += this.assertion[n4].b.length() * n3++;
            }
            ++n4;
        }
        return n2;
    }

    public String toString() {
        String string = null;
        int n2 = 0;
        while (n2 < this.assertion.length) {
            string = string == null ? this.assertion[n2].toString() : String.valueOf(string) + " + " + this.assertion[n2];
            ++n2;
        }
        return string;
    }
}

