/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.www.protocol.https;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl;
import com.sun.net.ssl.internal.ssl.X500Name;
import com.sun.net.ssl.internal.www.protocol.https.HttpClient;
import com.sun.net.ssl.internal.www.protocol.https.RegexpPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static final int a = 443;
    private SSLSocketFactory b;
    private String c;
    private int d;
    private SSLSession e;

    HttpsClient(URL uRL, String string, int n2) throws IOException {
        super(uRL, string, n2);
    }

    private HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL) throws IOException {
        super(sSLSocketFactory, uRL, true);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier) throws IOException {
        return HttpsClient.a(sSLSocketFactory, uRL, hostnameVerifier, true);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, boolean bl) throws IOException {
        HttpsClient httpsClient = null;
        if (bl) {
            httpsClient = (HttpsClient)HttpClient.kac.a(sSLSocketFactory, uRL);
        }
        if (httpsClient == null) {
            httpsClient = new HttpsClient(sSLSocketFactory, uRL);
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpsClient.url = uRL;
        }
        httpsClient.a(hostnameVerifier);
        return httpsClient;
    }

    private void a(HostnameVerifier hostnameVerifier) throws IOException {
        String string = null;
        try {
            Principal principal = this.e.getPeerCertificateChain()[0].getSubjectDN();
            X500Name x500Name = new X500Name(principal.getName());
            string = x500Name.getCommonName();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {}
        if (!(string != null && string.equalsIgnoreCase(this.url.getHost()) || hostnameVerifier != null && hostnameVerifier.verify(this.url.getHost(), string))) {
            this.serverSocket.close();
            this.e.invalidate();
            throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">, but cert says <" + string + ">");
        }
    }

    protected Socket doConnect(String string, int n2) throws IOException, UnknownHostException {
        String[] stringArray;
        this.c = this.c != null ? this.c : this.n();
        this.d = this.d != 0 ? this.d : this.o();
        SSLSocket sSLSocket = null;
        SSLSocketFactory sSLSocketFactory = this.b;
        if (this.c == null || this.isNonProxyHost()) {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n2);
        } else {
            try {
                stringArray = new Socket(this.c, this.d);
                this.a((Socket)stringArray, string, n2);
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket((Socket)stringArray, string, n2, true);
            }
            catch (IOException iOException) {
                try {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n2);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
        }
        SSLSocketFactoryImpl.checkCreate(sSLSocket);
        stringArray = this.l();
        if (stringArray != null) {
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.startHandshake();
        this.e = sSLSocket.getSession();
        return sSLSocket;
    }

    private void a(Socket socket, String string, int n2) throws IOException {
        String string2;
        byte[] byArray;
        OutputStream outputStream = socket.getOutputStream();
        String string3 = "CONNECT " + string + ":" + n2 + " HTTP/1.0\n" + "User-Agent: " + this.p() + "\r\n\r\n";
        try {
            byArray = string3.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string3.getBytes();
        }
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        boolean bl2 = false;
        while (n4 < 2) {
            int n5 = inputStream.read();
            if (n5 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n5 == 10) {
                bl = true;
                ++n4;
                continue;
            }
            if (n5 == 13) continue;
            n4 = 0;
            if (bl || n3 >= byArray2.length) continue;
            byArray2[n3++] = (byte)n5;
        }
        try {
            string2 = new String(byArray2, 0, n3, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray2, 0, n3);
        }
        if (!string2.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through " + this.c + ":" + this.d + ".  Proxy returns \"" + string2 + "\"");
        }
    }

    String a() {
        return this.e.getCipherSuite();
    }

    private String[] l() {
        String[] stringArray;
        String string = this.a("https.cipherSuites");
        if (string == null || "".equals(string)) {
            stringArray = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            stringArray = new String[vector.size()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
        return stringArray;
    }

    protected int getDefaultPort() {
        return 443;
    }

    private RegexpPool m() {
        RegexpPool regexpPool;
        block3: {
            regexpPool = new RegexpPool();
            String string = this.a("http.nonProxyHosts");
            if (string == null) break block3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    regexpPool.add(stringTokenizer.nextToken().toLowerCase(), new Boolean(true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return regexpPool;
    }

    private String n() {
        String string = this.a("https.proxyHost");
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private int o() {
        final int[] nArray = new int[1];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty("https.proxyHost") != null) {
                    nArray[0] = Integer.getInteger("https.proxyPort", 80);
                }
                return null;
            }
        });
        return nArray[0] < 0 ? super.getDefaultPort() : nArray[0];
    }

    SSLSocketFactory b() {
        return this.b;
    }

    X509Certificate[] c() {
        try {
            return this.e.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
    }

    private String a(String string) {
        final String string2 = string;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string2);
            }
        });
    }

    private String p() {
        String string = this.a("https.agent");
        if (string == null || string.length() == 0) {
            string = "JSSE";
        }
        return string;
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.e = handshakeCompletedEvent.getSession();
    }

    protected boolean isNonProxyHost() {
        RegexpPool regexpPool = this.m();
        if (regexpPool.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(this.url.getHost());
            String string = inetAddress.getHostAddress();
            if (regexpPool.match(string) != null) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return false;
    }

    void a(SSLSocketFactory sSLSocketFactory) {
        this.b = sSLSocketFactory;
    }
}

