/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cf;

import com.vmware.vim25.NotAuthenticated;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.PropertyCollector;
import com.vmware.vim25.mo.PropertyFilter;
import java.rmi.RemoteException;
import java.util.Observable;
import java.util.Vector;

class ManagedObjectWatcher
extends Observable
implements Runnable {
    private PropertyCollector pc;
    private Vector<PropertyFilter> filters = new Vector();
    private String version = "";

    public ManagedObjectWatcher(PropertyCollector pc) {
        this.pc = pc;
    }

    public void watch(ManagedObject[] mos, String[] propNames) {
        PropertyFilterSpec pfs = new PropertyFilterSpec();
        ObjectSpec[] oss = new ObjectSpec[mos.length];
        for (int i2 = 0; i2 < oss.length; ++i2) {
            oss[i2] = new ObjectSpec();
            oss[i2].setObj(mos[i2].getMOR());
        }
        pfs.setObjectSet(oss);
        PropertySpec ps = new PropertySpec();
        ps.setType(mos[0].getMOR().getType());
        ps.setPathSet(propNames);
        pfs.setPropSet(new PropertySpec[]{ps});
        this.watch(pfs);
    }

    public void watch(PropertyFilterSpec pfs) {
        try {
            PropertyFilter pf = this.pc.createFilter(pfs, true);
            this.filters.add(pf);
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    UpdateSet update = this.pc.waitForUpdates(this.version);
                    PropertyFilterUpdate[] pfu = update.getFilterSet();
                    this.setChanged();
                    this.notifyObservers(pfu);
                    this.version = update.getVersion();
                }
            }
            catch (NotAuthenticated na) {
                na.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void cleanUp() {
        for (int i2 = 0; i2 < this.filters.size(); ++i2) {
            try {
                this.filters.get(i2).destroyPropertyFilter();
                continue;
            }
            catch (RemoteException e2) {
                e2.printStackTrace();
            }
        }
    }
}

