/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.Stack;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.OpCode;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5MatchResult;
import org.apache.oro.text.regex.Perl5Pattern;
import org.apache.oro.text.regex.Perl5Repetition;

public final class Perl5Matcher
implements PatternMatcher {
    private static final char __EOS = '\uffff';
    private static final int __INITIAL_NUM_OFFSETS = 20;
    private boolean __multiline = false;
    private boolean __lastSuccess = false;
    private boolean __caseInsensitive = false;
    private char __previousChar;
    private char[] __input;
    private char[] __originalInput;
    private Perl5Repetition __currentRep;
    private int __numParentheses;
    private int __bol;
    private int __eol;
    private int __currentOffset;
    private int __endOffset;
    private char[] __program;
    private int __expSize;
    private int __inputOffset;
    private int __lastParen;
    private int[] __beginMatchOffsets;
    private int[] __endMatchOffsets;
    private Stack __stack = new Stack();
    private Perl5MatchResult __lastMatchResult = null;
    private static final int __DEFAULT_LAST_MATCH_END_OFFSET = -100;
    private int __lastMatchInputEndOffset = -100;

    private static boolean __compare(char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            if (n2 >= cArray.length) {
                return false;
            }
            if (n3 >= cArray2.length) {
                return false;
            }
            if (cArray[n2] != cArray2[n3]) {
                return false;
            }
            ++n5;
            ++n2;
            ++n3;
        }
        return true;
    }

    private static int __findFirst(char[] cArray, int n2, int n3, char[] cArray2) {
        if (cArray.length == 0) {
            return n3;
        }
        char c2 = cArray2[0];
        while (n2 < n3) {
            if (c2 == cArray[n2]) {
                int n4;
                int n5 = n2;
                for (n4 = 0; n2 < n3 && n4 < cArray2.length && cArray2[n4] == cArray[n2]; ++n4, ++n2) {
                }
                n2 = n5;
                if (n4 >= cArray2.length) break;
            }
            ++n2;
        }
        return n2;
    }

    private void __pushState(int n2) {
        int n3 = 3 * (this.__expSize - n2);
        int[] nArray = n3 <= 0 ? new int[3] : new int[n3 + 3];
        nArray[0] = this.__expSize;
        nArray[1] = this.__lastParen;
        nArray[2] = this.__inputOffset;
        int n4 = this.__expSize;
        while (n4 > n2) {
            nArray[n3] = this.__endMatchOffsets[n4];
            nArray[n3 + 1] = this.__beginMatchOffsets[n4];
            nArray[n3 + 2] = n4--;
            n3 -= 3;
        }
        this.__stack.push(nArray);
    }

    private void __popState() {
        int n2;
        int[] nArray = (int[])this.__stack.pop();
        this.__expSize = nArray[0];
        this.__lastParen = nArray[1];
        this.__inputOffset = nArray[2];
        for (int i2 = 3; i2 < nArray.length; i2 += 3) {
            n2 = nArray[i2 + 2];
            this.__beginMatchOffsets[n2] = nArray[i2 + 1];
            if (n2 > this.__lastParen) continue;
            this.__endMatchOffsets[n2] = nArray[i2];
        }
        for (n2 = this.__lastParen + 1; n2 <= this.__numParentheses; ++n2) {
            if (n2 > this.__expSize) {
                this.__beginMatchOffsets[n2] = -1;
            }
            this.__endMatchOffsets[n2] = -1;
        }
    }

    private void __initInterpreterGlobals(Perl5Pattern perl5Pattern, char[] cArray, int n2, int n3, int n4) {
        this.__caseInsensitive = perl5Pattern._isCaseInsensitive;
        this.__input = cArray;
        this.__endOffset = n3;
        this.__currentRep = new Perl5Repetition();
        this.__currentRep._numInstances = 0;
        this.__currentRep._lastRepetition = null;
        this.__program = perl5Pattern._program;
        this.__stack.setSize(0);
        if (n4 == n2 || n4 <= 0) {
            this.__previousChar = (char)10;
        } else {
            this.__previousChar = cArray[n4 - 1];
            if (!this.__multiline && this.__previousChar == '\n') {
                this.__previousChar = '\u0000';
            }
        }
        this.__numParentheses = perl5Pattern._numParentheses;
        this.__currentOffset = n4;
        this.__bol = n2;
        this.__eol = n3;
        n3 = this.__numParentheses + 1;
        if (this.__beginMatchOffsets == null || n3 > this.__beginMatchOffsets.length) {
            if (n3 < 20) {
                n3 = 20;
            }
            this.__beginMatchOffsets = new int[n3];
            this.__endMatchOffsets = new int[n3];
        }
    }

    private void __setLastMatchResult() {
        int n2 = 0;
        this.__lastMatchResult = new Perl5MatchResult(this.__numParentheses + 1);
        if (this.__endMatchOffsets[0] > this.__originalInput.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.__lastMatchResult._matchBeginOffset = this.__beginMatchOffsets[0];
        while (this.__numParentheses >= 0) {
            int n3 = this.__beginMatchOffsets[this.__numParentheses];
            this.__lastMatchResult._beginGroupOffset[this.__numParentheses] = n3 >= 0 ? n3 - this.__lastMatchResult._matchBeginOffset : -1;
            n3 = this.__endMatchOffsets[this.__numParentheses];
            if (n3 >= 0) {
                this.__lastMatchResult._endGroupOffset[this.__numParentheses] = n3 - this.__lastMatchResult._matchBeginOffset;
                if (n3 > n2 && n3 <= this.__originalInput.length) {
                    n2 = n3;
                }
            } else {
                this.__lastMatchResult._endGroupOffset[this.__numParentheses] = -1;
            }
            --this.__numParentheses;
        }
        this.__lastMatchResult._match = new String(this.__originalInput, this.__beginMatchOffsets[0], n2 - this.__beginMatchOffsets[0]);
        this.__originalInput = null;
    }

    private boolean __interpret(Perl5Pattern perl5Pattern, char[] cArray, int n2, int n3, int n4) {
        boolean bl;
        block82: {
            int n5;
            int n6;
            block87: {
                boolean bl2;
                block86: {
                    char[] cArray2;
                    block85: {
                        block83: {
                            block84: {
                                n6 = 0;
                                n5 = 0;
                                this.__initInterpreterGlobals(perl5Pattern, cArray, n2, n3, n4);
                                bl = false;
                                cArray2 = perl5Pattern._mustString;
                                if (cArray2 == null || (perl5Pattern._anchor & 3) != 0 && (!this.__multiline && (perl5Pattern._anchor & 2) == 0 || perl5Pattern._back < 0)) break block83;
                                this.__currentOffset = Perl5Matcher.__findFirst(this.__input, this.__currentOffset, n3, cArray2);
                                if (this.__currentOffset < n3) break block84;
                                if ((perl5Pattern._options & 0x8000) == 0) {
                                    ++perl5Pattern._mustUtility;
                                }
                                bl = false;
                                break block82;
                            }
                            if (perl5Pattern._back >= 0) {
                                this.__currentOffset -= perl5Pattern._back;
                                if (this.__currentOffset < n4) {
                                    this.__currentOffset = n4;
                                }
                                n6 = perl5Pattern._back + cArray2.length;
                            } else if (!perl5Pattern._isExpensive && (perl5Pattern._options & 0x8000) == 0 && --perl5Pattern._mustUtility < 0) {
                                perl5Pattern._mustString = null;
                                cArray2 = null;
                                this.__currentOffset = n4;
                            } else {
                                this.__currentOffset = n4;
                                n6 = cArray2.length;
                            }
                        }
                        if ((perl5Pattern._anchor & 3) == 0) break block85;
                        if (this.__currentOffset == n2 && this.__tryExpression(n2)) {
                            bl = true;
                        } else if (this.__multiline || (perl5Pattern._anchor & 2) != 0 || (perl5Pattern._anchor & 8) != 0) {
                            if (n6 > 0) {
                                n5 = n6 - 1;
                            }
                            n3 -= n5;
                            if (this.__currentOffset > n4) {
                                --this.__currentOffset;
                            }
                            while (this.__currentOffset < n3) {
                                if (this.__input[this.__currentOffset++] != '\n' || this.__currentOffset >= n3 || !this.__tryExpression(this.__currentOffset)) continue;
                                bl = true;
                                break block82;
                            }
                        }
                        break block82;
                    }
                    if (perl5Pattern._startString == null) break block86;
                    cArray2 = perl5Pattern._startString;
                    if ((perl5Pattern._anchor & 4) != 0) {
                        char c2 = cArray2[0];
                        while (this.__currentOffset < n3) {
                            if (c2 == this.__input[this.__currentOffset]) {
                                if (this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block82;
                                }
                                ++this.__currentOffset;
                                while (this.__currentOffset < n3 && this.__input[this.__currentOffset] == c2) {
                                    ++this.__currentOffset;
                                }
                            }
                            ++this.__currentOffset;
                        }
                    } else {
                        while ((this.__currentOffset = Perl5Matcher.__findFirst(this.__input, this.__currentOffset, n3, cArray2)) < n3) {
                            if (this.__tryExpression(this.__currentOffset)) {
                                bl = true;
                                break block82;
                            }
                            ++this.__currentOffset;
                        }
                    }
                    break block82;
                }
                int n7 = perl5Pattern._startClassOffset;
                if (n7 == -1) break block87;
                boolean bl3 = bl2 = (perl5Pattern._anchor & 4) == 0;
                if (n6 > 0) {
                    n5 = n6 - 1;
                }
                n3 -= n5;
                boolean bl4 = true;
                char c3 = this.__program[n7];
                block0 : switch (c3) {
                    case '\t': {
                        n7 = OpCode._getOperand(n7);
                        while (this.__currentOffset < n3) {
                            char c4 = this.__input[this.__currentOffset];
                            if (c4 < '\u0100' && (this.__program[n7 + (c4 >> 4)] & 1 << (c4 & 0xF)) == 0) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block82;
                    }
                    case '#': 
                    case '$': {
                        n7 = OpCode._getOperand(n7);
                        while (this.__currentOffset < n3) {
                            char c5 = this.__input[this.__currentOffset];
                            if (this.__matchUnicodeClass(c5, this.__program, n7, c3)) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block82;
                    }
                    case '\u0014': {
                        char c6;
                        if (n6 > 0) {
                            ++n5;
                            --n3;
                        }
                        if (this.__currentOffset != n2) {
                            c6 = this.__input[this.__currentOffset - 1];
                            bl4 = OpCode._isWordCharacter(c6);
                        } else {
                            bl4 = OpCode._isWordCharacter(this.__previousChar);
                        }
                        while (this.__currentOffset < n3) {
                            c6 = this.__input[this.__currentOffset];
                            if (bl4 != OpCode._isWordCharacter(c6)) {
                                boolean bl5 = bl4 = !bl4;
                                if (this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                            }
                            ++this.__currentOffset;
                        }
                        if ((n6 > 0 || bl4) && this.__tryExpression(this.__currentOffset)) {
                            bl = true;
                            break;
                        }
                        break block82;
                    }
                    case '\u0015': {
                        char c7;
                        if (n6 > 0) {
                            ++n5;
                            --n3;
                        }
                        if (this.__currentOffset != n2) {
                            c7 = this.__input[this.__currentOffset - 1];
                            bl4 = OpCode._isWordCharacter(c7);
                        } else {
                            bl4 = OpCode._isWordCharacter(this.__previousChar);
                        }
                        while (this.__currentOffset < n3) {
                            c7 = this.__input[this.__currentOffset];
                            if (bl4 != OpCode._isWordCharacter(c7)) {
                                bl4 = !bl4;
                            } else if (this.__tryExpression(this.__currentOffset)) {
                                bl = true;
                                break block0;
                            }
                            ++this.__currentOffset;
                        }
                        if ((n6 > 0 || !bl4) && this.__tryExpression(this.__currentOffset)) {
                            bl = true;
                            break;
                        }
                        break block82;
                    }
                    case '\u0012': {
                        while (this.__currentOffset < n3) {
                            char c8 = this.__input[this.__currentOffset];
                            if (OpCode._isWordCharacter(c8)) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block82;
                    }
                    case '\u0013': {
                        while (this.__currentOffset < n3) {
                            char c9 = this.__input[this.__currentOffset];
                            if (!OpCode._isWordCharacter(c9)) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block82;
                    }
                    case '\u0016': {
                        while (this.__currentOffset < n3) {
                            if (Character.isWhitespace(this.__input[this.__currentOffset])) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block82;
                    }
                    case '\u0017': {
                        while (this.__currentOffset < n3) {
                            if (!Character.isWhitespace(this.__input[this.__currentOffset])) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block82;
                    }
                    case '\u0018': {
                        while (this.__currentOffset < n3) {
                            if (Character.isDigit(this.__input[this.__currentOffset])) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block82;
                    }
                    case '\u0019': {
                        while (this.__currentOffset < n3) {
                            if (!Character.isDigit(this.__input[this.__currentOffset])) {
                                if (bl4 && this.__tryExpression(this.__currentOffset)) {
                                    bl = true;
                                    break block0;
                                }
                                bl4 = bl2;
                            } else {
                                bl4 = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block0;
                    }
                }
                break block82;
            }
            if (n6 > 0) {
                n5 = n6 - 1;
            }
            n3 -= n5;
            do {
                if (!this.__tryExpression(this.__currentOffset)) continue;
                bl = true;
                break;
            } while (this.__currentOffset++ < n3);
        }
        this.__lastSuccess = bl;
        this.__lastMatchResult = null;
        return bl;
    }

    private boolean __matchUnicodeClass(char c2, char[] cArray, int n2, char c3) {
        boolean bl;
        boolean bl2 = bl = c3 == '#';
        while (cArray[n2] != '\u0000') {
            if (cArray[n2] == '%') {
                if (c2 >= cArray[++n2] && c2 <= cArray[n2 + 1]) {
                    return bl;
                }
                n2 += 2;
                continue;
            }
            if (cArray[n2] == '1') {
                int n3 = ++n2;
                ++n2;
                if (cArray[n3] != c2) continue;
                return bl;
            }
            bl = cArray[n2] == '/' ? bl : !bl;
            int n4 = ++n2;
            ++n2;
            switch (cArray[n4]) {
                case '\u0012': {
                    if (!OpCode._isWordCharacter(c2)) break;
                    return bl;
                }
                case '\u0013': {
                    if (OpCode._isWordCharacter(c2)) break;
                    return bl;
                }
                case '\u0016': {
                    if (!Character.isWhitespace(c2)) break;
                    return bl;
                }
                case '\u0017': {
                    if (Character.isWhitespace(c2)) break;
                    return bl;
                }
                case '\u0018': {
                    if (!Character.isDigit(c2)) break;
                    return bl;
                }
                case '\u0019': {
                    if (Character.isDigit(c2)) break;
                    return bl;
                }
                case '2': {
                    if (!Character.isLetterOrDigit(c2)) break;
                    return bl;
                }
                case '&': {
                    if (!Character.isLetter(c2)) break;
                    return bl;
                }
                case '\'': {
                    if (!Character.isSpaceChar(c2)) break;
                    return bl;
                }
                case '(': {
                    if (!Character.isISOControl(c2)) break;
                    return bl;
                }
                case '*': {
                    if (Character.isLowerCase(c2)) {
                        return bl;
                    }
                    if (!this.__caseInsensitive || !Character.isUpperCase(c2)) break;
                    return bl;
                }
                case '-': {
                    if (Character.isUpperCase(c2)) {
                        return bl;
                    }
                    if (!this.__caseInsensitive || !Character.isLowerCase(c2)) break;
                    return bl;
                }
                case '+': {
                    if (Character.isSpaceChar(c2)) {
                        return bl;
                    }
                }
                case ')': {
                    if (Character.isLetterOrDigit(c2)) {
                        return bl;
                    }
                }
                case ',': {
                    switch (Character.getType(c2)) {
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: {
                            return bl;
                        }
                    }
                    break;
                }
                case '.': {
                    if (!(c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f') && (c2 < 'A' || c2 > 'F')) break;
                    return bl;
                }
                case '3': {
                    if (c2 >= '\u0080') break;
                    return bl;
                }
            }
        }
        return !bl;
    }

    private boolean __tryExpression(int n2) {
        this.__inputOffset = n2;
        this.__lastParen = 0;
        this.__expSize = 0;
        if (this.__numParentheses > 0) {
            for (int i2 = 0; i2 <= this.__numParentheses; ++i2) {
                this.__beginMatchOffsets[i2] = -1;
                this.__endMatchOffsets[i2] = -1;
            }
        }
        if (this.__match(1)) {
            this.__beginMatchOffsets[0] = n2;
            this.__endMatchOffsets[0] = this.__inputOffset;
            return true;
        }
        return false;
    }

    private int __repeat(int n2, int n3) {
        int n4 = this.__inputOffset;
        int n5 = this.__eol;
        if (n3 != 65535 && n3 < n5 - n4) {
            n5 = n4 + n3;
        }
        int n6 = OpCode._getOperand(n2);
        char c2 = this.__program[n2];
        switch (c2) {
            case '\u0007': {
                while (n4 < n5 && this.__input[n4] != '\n') {
                    ++n4;
                }
                break;
            }
            case '\b': {
                n4 = n5;
                break;
            }
            case '\u000e': {
                ++n6;
                while (n4 < n5 && this.__program[n6] == this.__input[n4]) {
                    ++n4;
                }
                break;
            }
            case '\t': {
                char c3;
                if (n4 >= n5 || (c3 = this.__input[n4]) >= '\u0100') break;
                while (c3 < '\u0100' && (this.__program[n6 + (c3 >> 4)] & 1 << (c3 & 0xF)) == 0 && ++n4 < n5) {
                    c3 = this.__input[n4];
                }
                break;
            }
            case '#': 
            case '$': {
                if (n4 >= n5) break;
                char c4 = this.__input[n4];
                while (this.__matchUnicodeClass(c4, this.__program, n6, c2) && ++n4 < n5) {
                    c4 = this.__input[n4];
                }
                break;
            }
            case '\u0012': {
                while (n4 < n5 && OpCode._isWordCharacter(this.__input[n4])) {
                    ++n4;
                }
                break;
            }
            case '\u0013': {
                while (n4 < n5 && !OpCode._isWordCharacter(this.__input[n4])) {
                    ++n4;
                }
                break;
            }
            case '\u0016': {
                while (n4 < n5 && Character.isWhitespace(this.__input[n4])) {
                    ++n4;
                }
                break;
            }
            case '\u0017': {
                while (n4 < n5 && !Character.isWhitespace(this.__input[n4])) {
                    ++n4;
                }
                break;
            }
            case '\u0018': {
                while (n4 < n5 && Character.isDigit(this.__input[n4])) {
                    ++n4;
                }
                break;
            }
            case '\u0019': {
                while (n4 < n5 && !Character.isDigit(this.__input[n4])) {
                    ++n4;
                }
                break;
            }
        }
        int n7 = n4 - this.__inputOffset;
        this.__inputOffset = n4;
        return n7;
    }

    private boolean __match(int n2) {
        boolean bl = true;
        boolean bl2 = false;
        int n3 = this.__inputOffset;
        bl = n3 < this.__endOffset;
        char c2 = bl ? this.__input[n3] : (char)'\uffff';
        int n4 = n2;
        int n5 = this.__program.length;
        while (n4 < n5) {
            int n6 = OpCode._getNext(this.__program, n4);
            char c3 = this.__program[n4];
            switch (c3) {
                case '\u0001': {
                    if (n3 == this.__bol ? this.__previousChar == '\n' : this.__multiline && (bl || n3 < this.__eol) && this.__input[n3 - 1] == '\n') break;
                    return false;
                }
                case '\u0002': {
                    if (n3 == this.__bol ? this.__previousChar == '\n' : (bl || n3 < this.__eol) && this.__input[n3 - 1] == '\n') break;
                    return false;
                }
                case '\u0003': {
                    if (n3 == this.__bol && this.__previousChar == '\n') break;
                    return false;
                }
                case '\u001e': {
                    if (n3 == this.__bol) break;
                    return true;
                }
                case '\u0004': {
                    if ((bl || n3 < this.__eol) && c2 != '\n') {
                        return false;
                    }
                    if (this.__multiline || this.__eol - n3 <= 1) break;
                    return false;
                }
                case '\u0005': {
                    if (!bl && n3 >= this.__eol || c2 == 10) break;
                    return false;
                }
                case '\u0006': {
                    if ((bl || n3 < this.__eol) && c2 != '\n') {
                        return false;
                    }
                    if (this.__eol - n3 <= 1) break;
                    return false;
                }
                case '\b': {
                    if (!bl && n3 >= this.__eol) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u0007': {
                    if (!bl && n3 >= this.__eol || c2 == '\n') {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u000e': {
                    int n7 = OpCode._getOperand(n4);
                    int n8 = this.__program[n7++];
                    if (this.__program[n7] != c2) {
                        return false;
                    }
                    if (this.__eol - n3 < n8) {
                        return false;
                    }
                    if (n8 > 1 && !Perl5Matcher.__compare(this.__program, n7, this.__input, n3, n8)) {
                        return false;
                    }
                    bl = (n3 += n8) < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\t': {
                    int n7 = OpCode._getOperand(n4);
                    if (c2 == '\uffff' && bl) {
                        c2 = this.__input[n3];
                    }
                    if (c2 >= '\u0100' || (this.__program[n7 + (c2 >> 4)] & 1 << (c2 & 0xF)) != 0) {
                        return false;
                    }
                    if (!bl && n3 >= this.__eol) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '#': 
                case '$': {
                    int n7 = OpCode._getOperand(n4);
                    if (c2 == '\uffff' && bl) {
                        c2 = this.__input[n3];
                    }
                    if (!this.__matchUnicodeClass(c2, this.__program, n7, c3)) {
                        return false;
                    }
                    if (!bl && n3 >= this.__eol) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u0012': {
                    if (!bl) {
                        return false;
                    }
                    if (!OpCode._isWordCharacter(c2)) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u0013': {
                    if (!bl && n3 >= this.__eol) {
                        return false;
                    }
                    if (OpCode._isWordCharacter(c2)) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u0014': 
                case '\u0015': {
                    boolean bl3 = n3 == this.__bol ? OpCode._isWordCharacter(this.__previousChar) : OpCode._isWordCharacter(this.__input[n3 - 1]);
                    boolean bl4 = OpCode._isWordCharacter(c2);
                    if (bl3 == bl4 != (this.__program[n4] == '\u0014')) break;
                    return false;
                }
                case '\u0016': {
                    if (!bl && n3 >= this.__eol) {
                        return false;
                    }
                    if (!Character.isWhitespace(c2)) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u0017': {
                    if (!bl) {
                        return false;
                    }
                    if (Character.isWhitespace(c2)) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u0018': {
                    if (!Character.isDigit(c2)) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u0019': {
                    if (!bl && n3 >= this.__eol) {
                        return false;
                    }
                    if (Character.isDigit(c2)) {
                        return false;
                    }
                    bl = ++n3 < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u001a': {
                    int n9 = OpCode._getArg1(this.__program, n4);
                    int n7 = this.__beginMatchOffsets[n9];
                    if (n7 == -1) {
                        return false;
                    }
                    if (this.__endMatchOffsets[n9] == -1) {
                        return false;
                    }
                    if (n7 == this.__endMatchOffsets[n9]) break;
                    if (this.__input[n7] != c2) {
                        return false;
                    }
                    int n8 = this.__endMatchOffsets[n9] - n7;
                    if (n3 + n8 > this.__eol) {
                        return false;
                    }
                    if (n8 > 1 && !Perl5Matcher.__compare(this.__input, n7, this.__input, n3, n8)) {
                        return false;
                    }
                    bl = (n3 += n8) < this.__endOffset;
                    c2 = bl ? this.__input[n3] : (char)'\uffff';
                    break;
                }
                case '\u000f': {
                    break;
                }
                case '\r': {
                    break;
                }
                case '\u001b': {
                    int n9 = OpCode._getArg1(this.__program, n4);
                    this.__beginMatchOffsets[n9] = n3;
                    if (n9 <= this.__expSize) break;
                    this.__expSize = n9;
                    break;
                }
                case '\u001c': {
                    int n9 = OpCode._getArg1(this.__program, n4);
                    this.__endMatchOffsets[n9] = n3;
                    if (n9 <= this.__lastParen) break;
                    this.__lastParen = n9;
                    break;
                }
                case '\u000b': {
                    Perl5Repetition perl5Repetition = new Perl5Repetition();
                    perl5Repetition._lastRepetition = this.__currentRep;
                    this.__currentRep = perl5Repetition;
                    perl5Repetition._parenFloor = this.__lastParen;
                    perl5Repetition._numInstances = -1;
                    perl5Repetition._min = OpCode._getArg1(this.__program, n4);
                    perl5Repetition._max = OpCode._getArg2(this.__program, n4);
                    perl5Repetition._scan = OpCode._getNextOperator(n4) + 2;
                    perl5Repetition._next = n6;
                    perl5Repetition._minMod = bl2;
                    perl5Repetition._lastLocation = -1;
                    this.__inputOffset = n3;
                    bl2 = this.__match(OpCode._getPrevOperator(n6));
                    this.__currentRep = perl5Repetition._lastRepetition;
                    return bl2;
                }
                case '\"': {
                    int n8;
                    Perl5Repetition perl5Repetition = this.__currentRep;
                    int n9 = perl5Repetition._numInstances + 1;
                    this.__inputOffset = n3;
                    if (n3 == perl5Repetition._lastLocation) {
                        this.__currentRep = perl5Repetition._lastRepetition;
                        n8 = this.__currentRep._numInstances;
                        if (this.__match(perl5Repetition._next)) {
                            return true;
                        }
                        this.__currentRep._numInstances = n8;
                        this.__currentRep = perl5Repetition;
                        return false;
                    }
                    if (n9 < perl5Repetition._min) {
                        perl5Repetition._numInstances = n9;
                        perl5Repetition._lastLocation = n3;
                        if (this.__match(perl5Repetition._scan)) {
                            return true;
                        }
                        perl5Repetition._numInstances = n9 - 1;
                        return false;
                    }
                    if (perl5Repetition._minMod) {
                        this.__currentRep = perl5Repetition._lastRepetition;
                        n8 = this.__currentRep._numInstances;
                        if (this.__match(perl5Repetition._next)) {
                            return true;
                        }
                        this.__currentRep._numInstances = n8;
                        this.__currentRep = perl5Repetition;
                        if (n9 >= perl5Repetition._max) {
                            return false;
                        }
                        this.__inputOffset = n3;
                        perl5Repetition._numInstances = n9;
                        perl5Repetition._lastLocation = n3;
                        if (this.__match(perl5Repetition._scan)) {
                            return true;
                        }
                        perl5Repetition._numInstances = n9 - 1;
                        return false;
                    }
                    if (n9 < perl5Repetition._max) {
                        this.__pushState(perl5Repetition._parenFloor);
                        perl5Repetition._numInstances = n9;
                        perl5Repetition._lastLocation = n3;
                        if (this.__match(perl5Repetition._scan)) {
                            return true;
                        }
                        this.__popState();
                        this.__inputOffset = n3;
                    }
                    this.__currentRep = perl5Repetition._lastRepetition;
                    n8 = this.__currentRep._numInstances;
                    if (this.__match(perl5Repetition._next)) {
                        return true;
                    }
                    perl5Repetition._numInstances = n8;
                    this.__currentRep = perl5Repetition;
                    perl5Repetition._numInstances = n9 - 1;
                    return false;
                }
                case '\f': {
                    int n9;
                    if (this.__program[n6] != '\f') {
                        n6 = OpCode._getNextOperator(n4);
                        break;
                    }
                    int n10 = this.__lastParen;
                    do {
                        this.__inputOffset = n3;
                        if (this.__match(OpCode._getNextOperator(n4))) {
                            return true;
                        }
                        for (n9 = this.__lastParen; n9 > n10; --n9) {
                            this.__endMatchOffsets[n9] = -1;
                        }
                        this.__lastParen = n9;
                    } while ((n4 = OpCode._getNext(this.__program, n4)) != -1 && this.__program[n4] == '\f');
                    return false;
                }
                case '\u001d': {
                    bl2 = true;
                    break;
                }
                case '\n': 
                case '\u0010': 
                case '\u0011': {
                    int n9;
                    int n8;
                    int n7;
                    if (c3 == '\n') {
                        n8 = OpCode._getArg1(this.__program, n4);
                        n9 = OpCode._getArg2(this.__program, n4);
                        n4 = OpCode._getNextOperator(n4) + 2;
                    } else if (c3 == '\u0010') {
                        n8 = 0;
                        n9 = 65535;
                        n4 = OpCode._getNextOperator(n4);
                    } else {
                        n8 = 1;
                        n9 = 65535;
                        n4 = OpCode._getNextOperator(n4);
                    }
                    if (this.__program[n6] == '\u000e') {
                        c2 = this.__program[OpCode._getOperand(n6) + 1];
                        n7 = 0;
                    } else {
                        c2 = '\uffff';
                        n7 = -1000;
                    }
                    this.__inputOffset = n3;
                    if (bl2) {
                        bl2 = false;
                        if (n8 > 0 && this.__repeat(n4, n8) < n8) {
                            return false;
                        }
                        while (n9 >= n8 || n9 == 65535 && n8 > 0) {
                            if ((n7 == -1000 || this.__inputOffset >= this.__endOffset || this.__input[this.__inputOffset] == c2) && this.__match(n6)) {
                                return true;
                            }
                            this.__inputOffset = n3 + n8;
                            if (this.__repeat(n4, 1) != 0) {
                                this.__inputOffset = n3 + ++n8;
                                continue;
                            }
                            return false;
                        }
                    } else {
                        if (n8 < (n9 = this.__repeat(n4, n9)) && OpCode._opType[this.__program[n6]] == '\u0004' && (!this.__multiline && this.__program[n6] != '\u0005' || this.__program[n6] == '\u0006')) {
                            n8 = n9;
                        }
                        while (n9 >= n8) {
                            if ((n7 == -1000 || this.__inputOffset >= this.__endOffset || this.__input[this.__inputOffset] == c2) && this.__match(n6)) {
                                return true;
                            }
                            this.__inputOffset = n3 + --n9;
                        }
                    }
                    return false;
                }
                case '\u0000': 
                case '!': {
                    this.__inputOffset = n3;
                    return this.__inputOffset != this.__lastMatchInputEndOffset;
                }
                case '\u001f': {
                    this.__inputOffset = n3;
                    n4 = OpCode._getNextOperator(n4);
                    if (this.__match(n4)) break;
                    return false;
                }
                case ' ': {
                    this.__inputOffset = n3;
                    n4 = OpCode._getNextOperator(n4);
                    if (!this.__match(n4)) break;
                    return false;
                }
            }
            n4 = n6;
        }
        return false;
    }

    public void setMultiline(boolean bl) {
        this.__multiline = bl;
    }

    public boolean isMultiline() {
        return this.__multiline;
    }

    char[] _toLower(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        cArray = cArray2;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!Character.isUpperCase(cArray[i2])) continue;
            cArray[i2] = Character.toLowerCase(cArray[i2]);
        }
        return cArray;
    }

    public boolean matchesPrefix(char[] cArray, Pattern pattern, int n2) {
        Perl5Pattern perl5Pattern = (Perl5Pattern)pattern;
        this.__originalInput = cArray;
        if (perl5Pattern._isCaseInsensitive) {
            cArray = this._toLower(cArray);
        }
        this.__initInterpreterGlobals(perl5Pattern, cArray, 0, cArray.length, n2);
        this.__lastSuccess = this.__tryExpression(n2);
        this.__lastMatchResult = null;
        return this.__lastSuccess;
    }

    public boolean matchesPrefix(char[] cArray, Pattern pattern) {
        return this.matchesPrefix(cArray, pattern, 0);
    }

    public boolean matchesPrefix(String string, Pattern pattern) {
        return this.matchesPrefix(string.toCharArray(), pattern, 0);
    }

    public boolean matchesPrefix(PatternMatcherInput patternMatcherInput, Pattern pattern) {
        char[] cArray;
        Perl5Pattern perl5Pattern = (Perl5Pattern)pattern;
        this.__originalInput = patternMatcherInput._originalBuffer;
        if (perl5Pattern._isCaseInsensitive) {
            if (patternMatcherInput._toLowerBuffer == null) {
                patternMatcherInput._toLowerBuffer = this._toLower(this.__originalInput);
            }
            cArray = patternMatcherInput._toLowerBuffer;
        } else {
            cArray = this.__originalInput;
        }
        this.__initInterpreterGlobals(perl5Pattern, cArray, patternMatcherInput._beginOffset, patternMatcherInput._endOffset, patternMatcherInput._currentOffset);
        this.__lastSuccess = this.__tryExpression(patternMatcherInput._currentOffset);
        this.__lastMatchResult = null;
        return this.__lastSuccess;
    }

    public boolean matches(char[] cArray, Pattern pattern) {
        Perl5Pattern perl5Pattern = (Perl5Pattern)pattern;
        this.__originalInput = cArray;
        if (perl5Pattern._isCaseInsensitive) {
            cArray = this._toLower(cArray);
        }
        this.__initInterpreterGlobals(perl5Pattern, cArray, 0, cArray.length, 0);
        this.__lastSuccess = this.__tryExpression(0) && this.__endMatchOffsets[0] == cArray.length;
        this.__lastMatchResult = null;
        return this.__lastSuccess;
    }

    public boolean matches(String string, Pattern pattern) {
        return this.matches(string.toCharArray(), pattern);
    }

    public boolean matches(PatternMatcherInput patternMatcherInput, Pattern pattern) {
        char[] cArray;
        Perl5Pattern perl5Pattern = (Perl5Pattern)pattern;
        this.__originalInput = patternMatcherInput._originalBuffer;
        if (perl5Pattern._isCaseInsensitive) {
            if (patternMatcherInput._toLowerBuffer == null) {
                patternMatcherInput._toLowerBuffer = this._toLower(this.__originalInput);
            }
            cArray = patternMatcherInput._toLowerBuffer;
        } else {
            cArray = this.__originalInput;
        }
        this.__initInterpreterGlobals(perl5Pattern, cArray, patternMatcherInput._beginOffset, patternMatcherInput._endOffset, patternMatcherInput._beginOffset);
        this.__lastMatchResult = null;
        if (this.__tryExpression(patternMatcherInput._beginOffset) && (this.__endMatchOffsets[0] == patternMatcherInput._endOffset || patternMatcherInput.length() == 0 || patternMatcherInput._beginOffset == patternMatcherInput._endOffset)) {
            this.__lastSuccess = true;
            return true;
        }
        this.__lastSuccess = false;
        return false;
    }

    public boolean contains(String string, Pattern pattern) {
        return this.contains(string.toCharArray(), pattern);
    }

    public boolean contains(char[] cArray, Pattern pattern) {
        Perl5Pattern perl5Pattern = (Perl5Pattern)pattern;
        this.__originalInput = cArray;
        if (perl5Pattern._isCaseInsensitive) {
            cArray = this._toLower(cArray);
        }
        return this.__interpret(perl5Pattern, cArray, 0, cArray.length, 0);
    }

    public boolean contains(PatternMatcherInput patternMatcherInput, Pattern pattern) {
        char[] cArray;
        if (patternMatcherInput._currentOffset > patternMatcherInput._endOffset) {
            return false;
        }
        Perl5Pattern perl5Pattern = (Perl5Pattern)pattern;
        this.__originalInput = patternMatcherInput._originalBuffer;
        this.__originalInput = patternMatcherInput._originalBuffer;
        if (perl5Pattern._isCaseInsensitive) {
            if (patternMatcherInput._toLowerBuffer == null) {
                patternMatcherInput._toLowerBuffer = this._toLower(this.__originalInput);
            }
            cArray = patternMatcherInput._toLowerBuffer;
        } else {
            cArray = this.__originalInput;
        }
        this.__lastMatchInputEndOffset = patternMatcherInput.getMatchEndOffset();
        boolean bl = this.__interpret(perl5Pattern, cArray, patternMatcherInput._beginOffset, patternMatcherInput._endOffset, patternMatcherInput._currentOffset);
        if (bl) {
            patternMatcherInput.setCurrentOffset(this.__endMatchOffsets[0]);
            patternMatcherInput.setMatchOffsets(this.__beginMatchOffsets[0], this.__endMatchOffsets[0]);
        } else {
            patternMatcherInput.setCurrentOffset(patternMatcherInput._endOffset + 1);
        }
        this.__lastMatchInputEndOffset = -100;
        return bl;
    }

    public MatchResult getMatch() {
        if (!this.__lastSuccess) {
            return null;
        }
        if (this.__lastMatchResult == null) {
            this.__setLastMatchResult();
        }
        return this.__lastMatchResult;
    }
}

