/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.xni.QName;

public class SubstitutionGroupHandler {
    XSGrammarBucket fGrammarBucket;
    Hashtable fSubGroups = new Hashtable();
    private static final XSElementDecl[] EMPTY_VECTOR = new XSElementDecl[0];

    public SubstitutionGroupHandler(XSGrammarBucket xSGrammarBucket) {
        this.fGrammarBucket = xSGrammarBucket;
    }

    public XSElementDecl getMatchingElemDecl(QName qName, XSElementDecl xSElementDecl) {
        if (qName.localpart == xSElementDecl.fName && qName.uri == xSElementDecl.fTargetNamespace) {
            return xSElementDecl;
        }
        if (xSElementDecl.fScope != 1) {
            return null;
        }
        if ((xSElementDecl.fBlock & 4) != 0) {
            return null;
        }
        SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(qName.uri);
        if (schemaGrammar == null) {
            return null;
        }
        XSElementDecl xSElementDecl2 = schemaGrammar.getGlobalElementDecl(qName.localpart);
        if (xSElementDecl2 == null) {
            return null;
        }
        if (this.substitutionGroupOK(xSElementDecl2, xSElementDecl, xSElementDecl.fBlock)) {
            return xSElementDecl2;
        }
        return null;
    }

    protected boolean substitutionGroupOK(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, short s2) {
        if ((s2 & 4) != 0) {
            return false;
        }
        int n2 = 0;
        short s3 = s2;
        XSTypeDefinition xSTypeDefinition = xSElementDecl.fType;
        n2 = xSTypeDefinition.getTypeCategory() == 13 ? (int)((XSComplexTypeDecl)xSTypeDefinition).fDerivedBy : 2;
        xSTypeDefinition = xSElementDecl2.fType;
        if (xSTypeDefinition.getTypeCategory() == 13) {
            s3 = (short)(s3 | ((XSComplexTypeDecl)xSTypeDefinition).fBlock);
        }
        XSElementDecl xSElementDecl3 = xSElementDecl.fSubGroup;
        while (xSElementDecl3 != null && xSElementDecl3 != xSElementDecl2) {
            xSTypeDefinition = xSElementDecl3.fType;
            if (xSTypeDefinition.getTypeCategory() == 13) {
                n2 = (short)(n2 | ((XSComplexTypeDecl)xSTypeDefinition).fDerivedBy);
                s3 = (short)(s3 | ((XSComplexTypeDecl)xSTypeDefinition).fBlock);
            } else {
                n2 = (short)(n2 | 2);
            }
            xSElementDecl3 = xSElementDecl3.fSubGroup;
        }
        if (xSElementDecl3 == null) {
            return false;
        }
        return (n2 & s3) == 0;
    }

    public boolean inSubstitutionGroup(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        while (xSElementDecl != null && xSElementDecl != xSElementDecl2) {
            xSElementDecl = xSElementDecl.fSubGroup;
        }
        return xSElementDecl != null;
    }

    public void reset() {
        this.fSubGroups.clear();
    }

    public void addSubstitutionGroup(XSElementDecl[] xSElementDeclArray) {
        int n2 = xSElementDeclArray.length - 1;
        while (n2 >= 0) {
            XSElementDecl xSElementDecl = xSElementDeclArray[n2];
            XSElementDecl xSElementDecl2 = xSElementDecl.fSubGroup;
            Vector<XSElementDecl> vector = (Vector<XSElementDecl>)this.fSubGroups.get(xSElementDecl2);
            if (vector == null) {
                vector = new Vector<XSElementDecl>();
                this.fSubGroups.put(xSElementDecl2, vector);
            }
            vector.addElement(xSElementDecl);
            --n2;
        }
    }

    public XSElementDecl[] getSubstitutionGroup(XSElementDecl xSElementDecl) {
        XSElementDecl[] xSElementDeclArray;
        Object v2 = this.fSubGroups.get(xSElementDecl);
        if (v2 == null) {
            xSElementDeclArray = EMPTY_VECTOR;
            this.fSubGroups.put(xSElementDecl, xSElementDeclArray);
        } else if (v2 instanceof XSElementDecl[]) {
            xSElementDeclArray = (XSElementDecl[])v2;
        } else {
            Vector vector = (Vector)v2;
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                XSElementDecl[] xSElementDeclArray2 = this.getSubstitutionGroup((XSElementDecl)vector.elementAt(n2));
                int n3 = xSElementDeclArray2.length - 1;
                while (n3 >= 0) {
                    vector.addElement(xSElementDeclArray2[n3]);
                    --n3;
                }
                --n2;
            }
            xSElementDeclArray = new XSElementDecl[vector.size()];
            int n4 = vector.size() - 1;
            while (n4 >= 0) {
                xSElementDeclArray[n4] = (XSElementDecl)vector.elementAt(n4);
                --n4;
            }
            this.fSubGroups.put(xSElementDecl, xSElementDeclArray);
        }
        return xSElementDeclArray;
    }
}

