/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.opti.DefaultXMLDocumentHandler;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Document;

public class SchemaDOMParser
extends DefaultXMLDocumentHandler {
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected XMLLocator fLocator;
    SchemaDOM schemaDOM = new SchemaDOM();
    XMLParserConfiguration config;
    private int fAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;

    public SchemaDOMParser(XMLParserConfiguration xMLParserConfiguration) {
        this.config = xMLParserConfiguration;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fLocator = xMLLocator;
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fAnnotationDepth == -1) {
            int n2 = xMLString.offset;
            while (n2 < xMLString.offset + xMLString.length) {
                if (!XMLChar.isSpace(xMLString.ch[n2])) {
                    Object object;
                    if (this.fErrorReporter == null) {
                        try {
                            this.fErrorReporter = (XMLErrorReporter)this.config.getProperty(ERROR_REPORTER);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                            object = new XSMessageFormatter();
                            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)object);
                        }
                    }
                    object = new String(xMLString.ch, n2, xMLString.length + xMLString.offset - n2);
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{object}, (short)1);
                    break;
                }
                ++n2;
            }
        } else {
            this.schemaDOM.characters(xMLString, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.schemaDOM.startElement(qName, xMLAttributes, augmentations, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
        ++this.fDepth;
        if (this.fAnnotationDepth == -1 && qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && (qName.localpart == SchemaSymbols.ELT_APPINFO || qName.localpart == SchemaSymbols.ELT_DOCUMENTATION)) {
            this.fAnnotationDepth = this.fDepth;
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.schemaDOM.emptyElement(qName, xMLAttributes, augmentations, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.schemaDOM.endElement(qName, augmentations);
        if (this.fAnnotationDepth == this.fDepth) {
            this.fAnnotationDepth = -1;
        }
        --this.fDepth;
    }

    public Document getDocument() {
        return this.schemaDOM;
    }
}

